% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/template_matching.R
\name{convFFT}
\alias{convFFT}
\title{Convolution of 3D Arrays using the Fourier Transform}
\usage{
convFFT(A, B, C, FFTA = NULL)
}
\arguments{
\item{A}{is a three-dimensional array (\dQuote{the template}).}

\item{B}{is a three-dimensional array (\dQuote{the target}).}

\item{C}{is a vector of length three (the center of \dQuote{the template}).}

\item{FFTA}{is the three-dimensional Fourier transform of \code{A}, this may
save time when looping over multiple \dQuote{targets}.}
}
\value{
A three-dimensional array, the same dimension as the input arrays,
  that is the convolution of the \dQuote{target} to the \dQuote{template} at
  all spatial locations.
}
\description{
Convolve a three-dimensinal array with another three-dimensional arry using
the Fast Fourier Transform (FFT).
}
\details{
The arrays \eqn{A} and \eqn{B} are transformed into the Fourier domain and
multiplied together (equivalent to a convolution in the image domain across
all spatial locations simultaneously).
}
\examples{
cube <- array(0, c(20,20,1))
cube[9:12,9:12,1] <- 1
tkernel <- array(0, c(20,20,1))
tkernel[,,1] <- c(.5, 1, .5, rep(0,20-3)) \%o\% c(.5, 1, .5, rep(0,20-3))
tcenter <- findCenter(ifelse(tkernel > 0, TRUE, FALSE))
out <- convFFT(tkernel, cube, tcenter)
out[8:13,8:13,1]  ## text output

par(mfrow=c(2,2))  ## graphic output
image(drop(tkernel), col=oro.nifti::tim.colors(), main="Template")
image(drop(cube), col=oro.nifti::tim.colors(), main="Target")
image(drop(out), col=oro.nifti::tim.colors(), main="Output")
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
Briggs, W.L. and Henson, V.E. (1995) \emph{The DFT: An Owner's
Manual for the Discrete Fourier Transform}, SIAM: Philadelphia.
}
\seealso{
\code{\link{fft}}, \code{\link{fastTemplateMatching}}, \code{\link{shift3D}}
}

