# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Distance Covariance
#'
#' @name dcov
#'
#' @details Implements the algorithm described in Chaudhuri, Hu (2019) \doi{10.1016/j.csda.2019.01.016} which only has O(n log(n)) complexity.
#'
#' @param x numeric vector
#' @param y numeric vector
#'
#' @usage dcov(x,y)
#'
#' @return Returns a numeric value: the distance covariance between x and y.
#'
#' @examples \dontrun{
#'
#' set.seed(1)
#' x < -rnorm(1000)
#' y < -x ^ 2
#'
#' dcov(x, y)
#' dvov(x, x)
#' dvov(y, y)
#'
#' }
#' @export
dcov <- function(x, y) {
    .Call(`_dccpp_dcov`, x, y)
}

#' @title Distance Correlation
#'
#' @name dcor
#'
#' @param x numeric vector
#' @param y numeric vector
#'
#' @usage dcor(x,y)
#'
#' @return Returns a numeric value: the distance correlation between x and y.
#'
#' @examples \dontrun{
#'
#' set.seed(1)
#' x < -rnorm(1000)
#' y < -x ^ 2
#'
#' dcor(x, y) # dcor shows dependence between x and y
#' cor(x, y) # cor does not detect any depencence due to nonlinearity
#'
#' }
#' @export
dcor <- function(x, y) {
    .Call(`_dccpp_dcor`, x, y)
}

