% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-compute.R
\name{collapse.tbl_sql}
\alias{collapse.tbl_sql}
\alias{compute.tbl_sql}
\alias{collect.tbl_sql}
\title{Compute results of a query}
\usage{
\method{collapse}{tbl_sql}(x, ...)

\method{compute}{tbl_sql}(
  x,
  name = unique_table_name(),
  temporary = TRUE,
  unique_indexes = list(),
  indexes = list(),
  analyze = TRUE,
  ...,
  cte = FALSE
)

\method{collect}{tbl_sql}(x, ..., n = Inf, warn_incomplete = TRUE, cte = FALSE)
}
\arguments{
\item{x}{A lazy data frame backed by a database query.}

\item{...}{other parameters passed to methods.}

\item{name}{Table name in remote database.}

\item{temporary}{Should the table be temporary (\code{TRUE}, the default\verb{) or persistent (}FALSE`)?}

\item{unique_indexes}{a list of character vectors. Each element of the list
will create a new unique index over the specified column(s). Duplicate rows
will result in failure.}

\item{indexes}{a list of character vectors. Each element of the list
will create a new index.}

\item{analyze}{if \code{TRUE} (the default), will automatically ANALYZE the
new table so that the query optimiser has useful information.}

\item{cte}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Use common table expressions in the generated SQL?}

\item{n}{Number of rows to fetch. Defaults to \code{Inf}, meaning all rows.}

\item{warn_incomplete}{Warn if \code{n} is less than the number of result rows?}
}
\description{
These are methods for the dplyr generics \code{\link[=collapse]{collapse()}}, \code{\link[=compute]{compute()}},
and \code{\link[=collect]{collect()}}. \code{collapse()} creates a subquery, \code{compute()} stores
the results in a remote table, and \code{collect()} executes the query and
downloads the data into R.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(a = c(3, 4, 1, 2), b = c(5, 1, 2, NA))
db \%>\% filter(a <= 2) \%>\% collect()
}
