% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_common_utilities.R
\name{get_xml_db_rows}
\alias{get_xml_db_rows}
\title{Reads drug bank xml database and set it in memory.}
\usage{
get_xml_db_rows(xml_db_name)
}
\arguments{
\item{xml_db_name}{string, full path for the drug bank xml or zip file.}
}
\value{
TRUE when sets the db tree in memory to be used by parser
methods and FALSE otherwise
}
\description{
\code{get_xml_db_rows} sets drug bank db xml full tree in memory
}
\details{
This functions reads drug bank xml database and sets the full tree
 save it in a predefined database via
\code{\link{open_db}} method. It takes one single optional argument to
in memory directly without returning it.
It must be called one before using parser functions, and once it is called
If \code{\link{get_xml_db_rows}} is called before for any reason, so
no need to call it again.
}
\examples{
\donttest{
get_xml_db_rows("db_full_path")
get_xml_db_rows(xml_db_name = "db_full_path")
}
}
