% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{parse_drug_affected_organisms}
\alias{parse_drug_affected_organisms}
\title{Extracts the drug affected organisms element and return data as data frame.}
\usage{
parse_drug_affected_organisms(save_table = FALSE)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}
}
\value{
drug affected organisms node attributes date frame
}
\description{
\code{parse_drug_affected_organisms} returns data frame of drug affected organisms elements.
}
\details{
This functions extracts the affected organisms element of drug node in drug bank
xml database with the option to save it in a predefined database via
\code{\link{open_db}} method. It takes one single optional argument to
save the returned dataframe in the database.
It must be called after \code{\link{get_xml_db_rows}} function like
any other parser function.
If \code{\link{get_xml_db_rows}} is called before for any reason, so
no need to call it again before calling this function.
}
\examples{
\donttest{
parse_drug_affected_organisms()
parse_drug_affected_organisms(TRUE)
parse_drug_affected_organisms(save_table = FALSE)
}
}
