% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhydro_get.R
\name{get_hydro}
\alias{get_hydro}
\alias{gethydro}
\title{Retrieve hydrologic data from the DBHYDRO Environmental Database}
\usage{
get_hydro(dbkey = NA, date_min = NA, date_max = NA, raw = FALSE, ...)
}
\arguments{
\item{dbkey}{character string specifying a unique data series.
See \code{\link[dbhydroR]{get_dbkey}}}

\item{date_min}{character date must be in YYYY-MM-DD format}

\item{date_max}{character date must be in YYYY-MM-DD format}

\item{raw}{logical default is FALSE, set to TRUE to return data in "long"
format with all comments, qa information, and database codes included.}

\item{...}{Options passed on to \code{\link[dbhydroR]{get_dbkey}}}
}
\description{
Retrieve hydrologic data from the DBHYDRO Environmental Database
}
\details{
\code{get_hydro} can be run in one of two ways. 

\itemize{

\item The first, is to identify one or more \code{dbkeys} before-hand that
correspond to unique data series and are passed to the \code{dbkey}
argument. \code{dbkeys} can be found by:
\itemize{ \item iterative calls to \code{\link{get_dbkey}} (see example)
\item using the ArcGIS Online Station Map
(\url{http://my.sfwmd.gov/WAB/EnvironmentalMonitoring/index.html}) 
\item using the DBHYDRO Browser
(\url{http://my.sfwmd.gov/dbhydroplsql/show_dbkey_info.main_menu}).
} 

\item The second way to run \code{get_hydro} is to specify additional
arguments to \code{...} which are passed to \code{\link{get_dbkey}}
on-the-fly. 

}
By default, \code{get_hydro} returns a cleaned output where metadata
(station-name, variable, measurement units) is wholly contained in the column
name. This is accomplished internally by the \code{\link{clean_hydro}}
function. If additional metadata such as lattitude and longitude are desired
set the \code{raw} argument to \code{TRUE}.
}
\examples{
\dontrun{
#One variable/station time series
get_hydro(dbkey = "15081", date_min = "2013-01-01", date_max = "2013-02-02")

#Multiple variable/station time series
get_hydro(dbkey = c("15081", "15069"),
date_min = "2013-01-01", date_max = "2013-02-02")

#Instantaneous hydro retrieval
get_hydro(dbkey = "IY639", date_min = "2015-11-01", date_max = "2015-11-04")

#Looking up unknown dbkeys on the fly
get_hydro(stationid = "JBTS", category = "WEATHER", 
param = "WNDS", freq = "DA", date_min = "2013-01-01", 
date_max = "2013-02-02")
}
}

