% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhydro_clean.R
\name{clean_hydro}
\alias{clean_hydro}
\alias{cleanhydro}
\title{Clean raw hydrologic DBHYDRO data retrievals}
\usage{
clean_hydro(dt)
}
\arguments{
\item{dt}{data.frame output of \code{\link[dbhydroR]{gethydro}}}
}
\description{
Converts output of \code{\link{get_hydro}} from long (each piece
of data on its own row) to wide format (each site x variable combination in
its own column). Metadata (station-name, variable, measurement units) is
parsed so that it is wholly contained in column names.
}
\examples{
\dontrun{
clean_hydro(gethydro(dbkey = "15081", date_min = "2013-01-01", date_max = "2013-02-02", raw = TRUE))
}
}

