% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhydro_get.R
\name{getdbkey}
\alias{getdbkey}
\title{Query dbkey information}
\usage{
getdbkey(category, stationid = NA, param = NA, freq = NA, stat = NA,
  recorder = NA, agency = NA, strata = NA, detail.level = "summary",
  ...)
}
\arguments{
\item{category}{character string, choice of "WEATHER", "SW", "GW", or "WQ"}

\item{stationid}{character string specifying station name}

\item{param}{character string specifying desired parameter name}

\item{freq}{character string specifying collection frequency (daily = "DA")}

\item{stat}{character string specifying statistic type}

\item{recorder}{character string specifying recorder information}

\item{agency}{character string specifying collector agency}

\item{strata}{numeric vector of length 2 specifying a range of z-coordinates relative to local ground elevation. Only applicable for queries in the "WEATHER" and "GW" categories.}

\item{detail.level}{character string specifying the level of detail to return. Choices are "full", "summary", and "dbkey".}

\item{...}{Options passed as named parameters}
}
\description{
Retrieve a data.frame summary including dbkeys or a vector of dbkeys corresponding to specified parameters
}
\details{
A value in the "Recorder" field of "PREF" should be used whenever possible. This indicates that the dataset has been checked by the SFWMD modelling group.
}
\examples{
\dontrun{
# Weather
getdbkey(stationid = "JBTS", category = "WEATHER", param = "WNDS", detail.level = "summary")
getdbkey(stationid = "JBTS", category = "WEATHER", param = "WNDS", detail.level = "dbkey")

# query on multiple values
getdbkey(stationid = c("MBTS", "JBTS"), category = "WEATHER",
param = "WNDS", freq = "DA", detail.level = "dbkey")


# Surfacewater
getdbkey(stationid = "C111\%", category = "SW")

# Groundwater
getdbkey(stationid = "C111\%", category = "GW")
getdbkey(stationid = "C111AE", category = "GW", param = "WELL",
freq = "DA", stat = "MEAN", strata = c(9, 22), recorder = "TROL",
 agency = "WMD", detail.level = "full")

# Water Quality
getdbkey(stationid = "C111\%", category = "WQ")
}
}
\references{
\url{http://my.sfwmd.gov/dbhydroplsql/show_dbkey_info.main_menu}

\url{http://my.sfwmd.gov/dbhydroplsql/show_dbkey_info.show_meta_data}
}

