% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_data.R
\name{label_data}
\alias{label_data}
\title{Label the data}
\usage{
label_data(DD.dict, DS.data, non.NA.missing.codes = NA)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{non.NA.missing.codes}{A user-defined vector of numerical missing value codes (e.g., -9999).}
}
\value{
A tibble containing the labelled data set, with the data dictionary information embedded as attributes and variables labelled using Haven SPSS conventions.
}
\description{
Using the information in the data dictionary, this function adds non-missing information from the data dictionary as attributes to the data.
}
\examples{
data(ExampleB)
DS_labelled_data <- label_data(DD.dict.B, DS.data.B, non.NA.missing.codes=c(-9999))
labelled::var_label(DS_labelled_data$SEX)
labelled::val_labels(DS_labelled_data$SEX)
attributes(DS_labelled_data$SEX)
labelled::na_values(DS_labelled_data$HX_DEPRESSION)
}
