% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone.r
\name{mode_tz}
\alias{mode_tz}
\alias{mode_tz.datetimeoffset}
\alias{mode_tz.default}
\title{Get most common time zone}
\usage{
mode_tz(x, ...)

\method{mode_tz}{datetimeoffset}(x, tz = "", ...)

\method{mode_tz}{default}(x, ...)
}
\arguments{
\item{x}{A datetime object.}

\item{...}{Ignored}

\item{tz}{A timezone string to use for missing time zones.
"" will be treated as equivalent to \code{Sys.timezone()}.}
}
\value{
Timezone string
}
\description{
'mode_tz()' gets the most common time zone
in the datetime object.  If a tie we use the time zone used first.
Intended for use when coercing from a datetime object that supports
multiple heterogeneous time zones to a datetime object that
only supports one time zone
}
\examples{
  dt <- as_datetimeoffset(Sys.time())
  print(mode_tz(dt))
  if (all(c("America/Los_Angeles", "America/New_York") \%in\% OlsonNames())) {
    dt <- as_datetimeoffset("2020-01-01",
                             tz = c("America/Los_Angeles", "America/New_York"))
    print(mode_tz(dt))

    print(Sys.timezone()) # timezone to be used for missing time zones
    dt <- as_datetimeoffset("2020-01-01",
                             tz = c("America/New_York", NA_character_, NA_character_))
    print(mode_tz(dt))
  }
}
