% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone.r
\name{getset_utc_offsets}
\alias{getset_utc_offsets}
\alias{get_utc_offsets}
\alias{set_utc_offsets}
\title{Get/set UTC offset strings}
\usage{
get_utc_offsets(x, sep = ":")

set_utc_offsets(x, value)
}
\arguments{
\item{x}{A \code{\link[=datetimeoffset]{datetimeoffset()}} object}

\item{sep}{Separator between hour and minute offsets.  Either ":" or "".}

\item{value}{Replace UTC offset string}
}
\value{
\code{get_utc_offsets()} returns a character string of UTC offset info.
\code{set_utc_offsets()} returns a datetime (whose UTC offset info has been set).
}
\description{
\code{get_utc_offsets()} and \code{set_utc_offsets()} gets/sets UTC offset strings
}
\examples{
  dt <- as_datetimeoffset("2020-01-01T01:01")
  get_utc_offsets(dt)
  dt <- set_utc_offsets(dt, "-07:00")
  get_utc_offsets(dt)
  dt <- set_utc_offsets(dt, "+0800")
  get_utc_offsets(dt)
  dt <- set_utc_offsets(dt, "+00")
  get_utc_offsets(dt)
  dt <- set_utc_offsets(dt, NA_character_)
  get_utc_offsets(dt)
}
\seealso{
\code{\link[=get_hour_offset]{get_hour_offset()}}, \code{\link[=set_hour_offset]{set_hour_offset()}}, \code{\link[=get_minute_offset]{get_minute_offset()}}, and \code{\link[=set_minute_offset]{set_minute_offset()}}
allow getting/setting the separate individual hour/minute offset components with integers.
\code{\link[=fill_utc_offsets]{fill_utc_offsets()}} fills any missing UTC offsets using non-missing time zones.
}
