% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_add_dates.R
\name{tree_add_dates}
\alias{tree_add_dates}
\title{Add missing taxa to a dated tree and fabricate node ages for these missing taxa.}
\usage{
tree_add_dates(
  dated_tree = NULL,
  missing_taxa = NULL,
  dating_method = "mrbayes",
  adding_criterion = "random",
  mrbayes_output_file = "mrbayes_tree_add_dates.nexus"
)
}
\arguments{
\item{dated_tree}{a tree (newick or phylo) with branch lengths proportional to absolute time}

\item{missing_taxa}{A tree, a data frame or a vector enlisting all missing taxa you want to include.
\describe{
\item{A tree}{Either as a phylo object or as a newick character string.
It contains all taxa that you want at the end, both missing and non missing.
This tree will be used as a hard constraint.}
\item{A \code{data.frame}}{It contains two columns named "taxon" and "clade".
The first one contains a character vector of missing taxon names.
The second one contains a character or numeric vector of nodes from a
constraint tree to which each taxon will be assigned.}
\item{A character vector}{It contains the names of the missing taxa.
They will be added at random to the constraint tree.}
}}

\item{dating_method}{The method used for tree dating, options are "mrbayes" and "bladj".}

\item{adding_criterion}{Only used when \code{dating_method = "mrbayes"}. A character vector to specify how missing_taxa should be added to dated_tree.
Choose one of:
\describe{
\item{adding_method = "random"}{missing_taxa will be added at random to dated_tree.
}
\item{adding_method = "taxonomy"}{taxa will be added to dated_tree following a dataframe with taxonomic assignations given in missing_taxa argument. If no dataframe is given, OpenTree's reference taxonomy will be used.
}
\item{adding_method = "tree"}{taxa will be added to dated_tree following a tree given in missing_taxa argument. If no tree is given, OpenTree's synthetic tree will be used.
}
}}

\item{mrbayes_output_file}{A character vector specifying the name of mrBayes run file and outputs (can specify directory too).}
}
\value{
A \code{phylo} object.
}
\description{
This function adds missing taxa to a chronogram given in \code{dated_tree}.
It is still work in progress.
}
