% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_calibrations.R
\name{get_all_calibrations}
\alias{get_all_calibrations}
\alias{datelife_calibrations}
\title{Get secondary calibrations from a set of given taxon names}
\usage{
get_all_calibrations(input = NULL, each = FALSE)
}
\arguments{
\item{input}{One of the following:
\describe{
\item{A character vector}{With taxon names as a single comma separated
starting or concatenated with \code{\link[=c]{c()}}.}
\item{A phylogenetic tree with taxon names as tip labels}{As a \code{phylo} or
\code{multiPhylo} object, OR as a newick character string.}
\item{A \code{datelifeQuery} object}{An output from \code{\link[=make_datelife_query]{make_datelife_query()}}.}
}}

\item{each}{Boolean, default to \code{FALSE}: all calibrations are returned in
the same \code{data.frame}. If \code{TRUE}, calibrations from each chronogram are returned
in separate data frames.}
}
\value{
An object of class \code{datelifeCalibrations}, i.e., a \code{data.frame} (if
\code{each = FALSE}) or a list of \code{data.frames} (if \code{each = TRUE}) of secondary
calibrations, for each pair of taxon names in \code{input}. The attribute
\code{chronograms} stores the \code{input} data from which the calibrations were extracted.
}
\description{
\code{get_all_calibrations} performs a \code{\link[=datelife_search]{datelife_search()}}
and gets divergence times (i.e., secondary calibrations) for each taxon name
pair given in \code{input}.
}
