% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_empty.R
\name{remove_empty}
\alias{remove_empty}
\alias{empty_columns}
\alias{empty_rows}
\alias{remove_empty_columns}
\alias{remove_empty_rows}
\title{Return or remove variables or observations that are completely missing}
\usage{
empty_columns(x)

empty_rows(x)

remove_empty_columns(x)

remove_empty_rows(x)

remove_empty(x)
}
\arguments{
\item{x}{A data frame.}
}
\value{
\itemize{
\item For \code{empty_columns()} and \code{empty_rows()}, a numeric (named) vector with row
or column indices of those variables that completely have missing values.
\item For \code{remove_empty_columns()} and \code{remove_empty_rows()}, a data frame with
"empty" columns or rows removed, respectively.
\item For \code{remove_empty()}, \strong{both} empty rows and columns will be removed.
}
}
\description{
These functions check which rows or columns of a data frame completely
contain missing values, i.e. which observations or variables completely have
missing values, and either (1) returns their indices; or (2) removes them
from the data frame.
}
\details{
For character vectors, empty string values (i.e. \code{""}) are also
considered as missing value. Thus, if a character vector only contains \code{NA}
and \code{""}, it is considered as empty variable and will be removed. Same
applies to observations (rows) that only contain \code{NA} or \code{""}.
}
\examples{
tmp <- data.frame(
  a = c(1, 2, 3, NA, 5),
  b = c(1, NA, 3, NA, 5),
  c = c(NA, NA, NA, NA, NA),
  d = c(1, NA, 3, NA, 5)
)

tmp

# indices of empty columns or rows
empty_columns(tmp)
empty_rows(tmp)

# remove empty columns or rows
remove_empty_columns(tmp)
remove_empty_rows(tmp)

# remove empty columns and rows
remove_empty(tmp)

# also remove "empty" character vectors
tmp <- data.frame(
  a = c(1, 2, 3, NA, 5),
  b = c(1, NA, 3, NA, 5),
  c = c("", "", "", "", ""),
  stringsAsFactors = FALSE
)
empty_columns(tmp)

}
