% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center.R
\name{center}
\alias{center}
\alias{centre}
\alias{center.numeric}
\alias{center.data.frame}
\title{Centering (Grand-Mean Centering)}
\usage{
center(x, ...)

centre(x, ...)

\method{center}{numeric}(x, weights = NULL, robust = FALSE, verbose = TRUE, ...)

\method{center}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  weights = NULL,
  robust = FALSE,
  force = FALSE,
  append = FALSE,
  suffix = "_c",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A data frame, a (numeric or character) vector or a factor.}

\item{...}{Currently not used.}

\item{weights}{Can be \code{NULL} (for no weighting), or:
\itemize{
\item For data frames: a numeric vector of weights, or a character of the
name of a column in the \code{data.frame} that contains the weights.
\item For numeric vectors: a numeric vector of weights.
}}

\item{robust}{Logical, if \code{TRUE}, centering is done by subtracting the
median from the variables. If \code{FALSE}, variables are centered by
subtracting the mean.}

\item{verbose}{Toggle warnings and messages.}

\item{select}{Character vector of column names. If \code{NULL} (the default),
all variables will be selected.}

\item{exclude}{Character vector of column names to be excluded from selection.}

\item{force}{Logical, if \code{TRUE}, forces centering of factors as
well. Factors are converted to numerical values, with the lowest level
being the value \code{1} (unless the factor has numeric levels, which are
converted to the corresponding numeric value).}

\item{append}{Logical, if \code{TRUE} and \code{x} is a data frame,
standardized variables will be added as additional columns; if
\code{FALSE}, existing variables are overwritten.}

\item{suffix}{Character value, will be appended to variable (column) names of
\code{x}, if \code{x} is a data frame and \code{append = TRUE}.}
}
\value{
The centered variables.
}
\description{
Performs a grand-mean centering of data.
}
\note{
\strong{Difference between centering and standardizing}: Standardized variables
are computed by subtracting the mean of the variable and then dividing it by
the standard deviation, while centering variables involves only the
subtraction.
}
\examples{
data(iris)
head(iris$Sepal.Width)
head(center(iris$Sepal.Width))
head(center(iris))
head(center(iris, force = TRUE))
}
\seealso{
If centering within-clusters (instead of grand-mean centering)
is required, see \code{\link[=demean]{demean()}}.
}
