\name{whos}
\alias{whos}
\alias{whos.all}
\title{Display contents of an evironment, data.frame or list as a summary table}
\usage{
  whos(pattern = "", envir = as.environment(-1),
    exclude = getOption("whos.mask"))

  whos.all(...)
}
\arguments{
  \item{pattern}{Regexp filtering of objects. Only objects
  matching the pattern are displayed. Optional, default:
  show all objects.}

  \item{envir}{Environment, data frame or list to be
  displayed. Optional, default: globalenv()}

  \item{exclude}{A list of objects not to be displayed. To
  set a default exclusion mask use the \code{whos.set.mask}
  function. If \code{whos.set.mask} is called without a
  list of object names all objects currently in globalenv()
  are hidden. This is useful for example if you have a lot
  of stuff in the workspace that you aren't currently
  interested in but is needed to make your code run.}

  \item{...}{Parameters sent to \code{\link{whos}}.}
}
\value{
  Nothing

  Nothing
}
\description{
  Color coded according to class and dimensions of
  contents. See \code{\link[xtermStyle]{style}} for
  details.

  Shortcut for calling whos without exclusion.
}
\examples{
whos()
data(USArrests)
whos(USArrests)

whos.set.mask()
data(iris)
whos()
whos.all()
}
\author{
  Christofer \enc{Bäcklin}{Backlin}

  Christofer \enc{Bäcklin}{Backlin}
}

