% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_type_general.R
\name{resource_type_general}
\alias{resource_type_general}
\alias{resource_type_general<-}
\alias{resource_type_general_allowed}
\alias{resource_type_general_verify}
\title{Get/set the resourceTypeGeneral property of a (related) item}
\usage{
resource_type_general(relitem)

resource_type_general(relitem) <- value

resource_type_general_allowed()

resource_type_general_verify(resourceTypeGeneral)
}
\arguments{
\item{relitem}{An object created by \code{\link{related_item_identifier}}.}

\item{value}{The general type of a resource (file), see
\href{https://support.datacite.org/docs/datacite-metadata-schema-v44-mandatory-properties#101-resourcetypegeneral}{DataCite 4.4 10.1 resourceTypeGeneral}.}

\item{resourceTypeGeneral}{The general type of a resource or file.
See \code{\link{resource_type_general}} for allowed values and validation.}
}
\value{
Get or set the resourceTypeGeneral property of a related item created with
\code{\link{related_item}}.
}
\description{
The general type of a resource (file), see
\href{https://support.datacite.org/docs/datacite-metadata-schema-v44-mandatory-properties#101-resourcetypegeneral}{DataCite 4.4 10.1 resourceTypeGeneral}.
}
\details{
Use \code{resource_type_general_allowed} to get the allowed controlled list of
resourcetypes from \code{DataCite 4.4}.\cr
\code{\link{resource_type_general_verify}} verifies if your property is among the allowed
values in the DataCite 4.4 definition.
}
\examples{
my_item <- related_item (Identifier = "https://zenodo.org/record/5703222#.YZYkm2DMLIU",
                         Creator = person ("Daniel", "Antal", role = "aut"),
                         Publisher = "Zenodo",
                         PublicationYear = 2022,
                         relatedIdentifierType = "DOI",
                         relationType = "CompiledBy",
                         schemeURI = "URI",
                         resourceTypeGeneral = "Dataset")
}
\seealso{
related_item
}
