% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasaurus-package.R
\docType{data}
\name{datasaurus_dozen}
\alias{datasaurus_dozen}
\title{Datasaurus Dozen data}
\format{
A data frame with 1846 rows and 3 variables:
\itemize{
\item \strong{dataset}: indicates which dataset the data are from
\item \strong{x}: x-values
\item \strong{y}: y-values
}
}
\usage{
datasaurus_dozen
}
\description{
A dataset demonstrating the utility of visualization.
These 12 datasets are equal in standard measures: mean,
standard deviation, and Pearson's correlation.
}
\examples{
if (require(ggplot2)) {
  ggplot(datasaurus_dozen, aes(x = x, y = y, colour = dataset)) +
    geom_point() +
    theme_void() +
    theme(legend.position = "none") +
    facet_wrap(~dataset, ncol = 3)
}

# Base R plots
state = par("mar", "mfrow")

# plot
par(mfrow = c(5, 3), mar = c(1, 2, 2, 1))

sets = sort(unique(datasaurus_dozen$dataset))

for (s in sets) {
  df = datasaurus_dozen[datasaurus_dozen$dataset == s, ]
  plot(df$x, df$y, pch = 16)
  title(s)
}

#reset settings
par(state)
}
\references{
Matejka, J., & Fitzmaurice, G. (2017).
Same Stats, Different Graphs: Generating Datasets with
Varied Appearance and Identical Statistics through Simulated
Annealing. \emph{CHI 2017 Conference proceedings: ACM SIGCHI
Conference on Human Factors in Computing Systems.}
Retrieved from \url{https://www.research.autodesk.com/publications/same-stats-different-graphs/}. #nolint
}
\keyword{datasets}
