% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Datasaurus-package.r
\docType{data}
\name{simpsons_paradox}
\alias{simpsons_paradox}
\title{Simpsons Paradox data}
\format{A data frame with 444 rows and 3 variables:
\itemize{
\item \strong{dataset}: indicates which of the two datasets the data are from, \code{simpson_1} or \code{simpson_2}
\item \strong{x}: x-values
\item \strong{y}: y-values
}}
\usage{
simpsons_paradox
}
\description{
A dataset demonstrating Simpson's Paradox with a strongly positively correlated dataset (\code{simpson_1})
and a dataset with the same positive correlation as \code{simpson_1}, but where individual groups have a
strong negative correlation (\code{simpson_2}).
}
\examples{
if(require(ggplot2)){
  ggplot(simpsons_paradox, aes(x=x, y=y, colour=dataset))+
    geom_point()+
    theme(legend.position = "none")+
    facet_wrap(~dataset, ncol=3)
}
}
\references{
Matejka, J., & Fitzmaurice, G. (2017).
Same Stats, Different Graphs: Generating Datasets with
Varied Appearance and Identical Statistics through Simulated
Annealing. \emph{CHI 2017 Conference proceedings: ACM SIGCHI
Conference on Human Factors in Computing Systems.}
Retrieved from \url{https://www.autodeskresearch.com/publications/samestats}.
}
\keyword{datasets}
