% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDeployment.R
\name{GetModelDeploymentServiceStatistics}
\alias{GetModelDeploymentServiceStatistics}
\title{Retrieve a health overview of a model deployment.}
\usage{
GetModelDeploymentServiceStatistics(modelDeploymentId, startDate, endDate)
}
\arguments{
\item{modelDeploymentId}{character. ID of the model deployment to retrieve.}

\item{startDate}{character. Optional. Filter statistics to be at this datetime or later.}

\item{endDate}{character. Optional. Filter statistics to be at this datetime or earlier.}
}
\value{
dataRobotModelDeploymentServiceHealth object containing the following information:
\itemize{
  \item totalRequests integer. The total number of requests performed. 0 if no requests.
  \item consumers integer. The total number of unique users performing requests.
  \item period list. A list with \code{start} and \code{end} that denote the boundaries
    of the time period the stats are reported for. This is a half-open time interval
    specifying [start: end).
  \item userErrorRate list. A list with \code{current} and \code{previous} that denote
    the ratio of user errors to the total number of requests performed for the given
    period and one time period before that.
  \item serverErrorRate list. A list with \code{current} and \code{previous} that denote
    the ratio of server errors to the total number of requests performed for the given
    period and one time period before that.
  \item load list. A list with \code{peak} and \code{median} that denote the max and the
    median request rate (in requests per minute) across all requests for the duration of
    the given time period.
  \item medianExecutionTime integer. The median of the execution time across all performed
    requests, in seconds. Will be \code{NULL} if there have been no requests.
}
}
\description{
Retrieve a health overview of a model deployment.
}
\examples{
\dontrun{
  modelDeploymentId <- "59a5af20c80891534e3c2bde"
  serviceHealth <- GetModelDeploymentServiceStatistics(modelDeploymentId)
  serviceHealth2 <- GetModelDeploymentServiceStatistics(modelDeploymentId,
}
}
