% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jobs.R
\name{GetJob}
\alias{GetJob}
\title{Request information about a job}
\usage{
GetJob(project, jobId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{jobId}{Character string specifying the job id}
}
\value{
list with following elements:
\describe{
  \item{status}{job status; an element of JobStatus, e.g. JobStatus$Queue}
  \item{url}{Character string: URL to request more detail about the job}
  \item{id}{Character string specifying the job id}
  \item{jobType}{Job type. See JobType for valid values}
  \item{projectId}{Character string specifying the project that contains the model}
}
}
\description{
Request information about a job
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- GetModelJobs(project)
  job <- initialJobs[[1]]
  jobId <- job$modelJobId
  GetJob(projectId, jobId)
}
}
