% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{CreateGroupPartition}
\alias{CreateGroupPartition}
\title{Create a group-based S3 object of class partition for the SetTarget function}
\usage{
CreateGroupPartition(validationType, holdoutPct, partitionKeyCols,
  reps = NULL, validationPct = NULL)
}
\arguments{
\item{validationType}{Character string specifying the type of partition
generated, either 'TVH' or 'CV'.}

\item{holdoutPct}{Integer, giving the percentage of data to be used
as the holdout subset.}

\item{partitionKeyCols}{List containing character string specifying the name of
the variable used in defining the group partition.}

\item{reps}{Integer, specifying the number of cross-validation folds to
generate; only applicable when validationType = 'CV'.}

\item{validationPct}{Integer, giving the percentage of data to be used
as the validation subset.}
}
\value{
An S3 object of class 'partition' including the parameters required
by the SetTarget function to generate a group-based partitioning of
the modeling dataset.
}
\description{
Group partitioning constructs data partitions such that all records with each
level in the column or columns specified by the parameter partitionKeyCols occurs
together in the same partition.
}
\details{
This function is one of several convenience functions provided to simplify the task
of starting modeling projects with custom partitioning options. The other
functions are CreateRandomPartition, CreateStratifiedPartition, and CreateUserPartition.
}
