% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionDatasets.R
\name{UploadPredictionDataset}
\alias{UploadPredictionDataset}
\title{Function to upload new data to a DataRobot project for predictions}
\usage{
UploadPredictionDataset(project, dataSource, maxWait = 60)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this identifier.}

\item{dataSource}{Either (a) the name of a CSV file or (b) a dataframe;
in either case, this parameter identifies the source of the data from which
all project models will be built.  See Details.}

\item{maxWait}{The maximum time (in seconds) to wait for each of two steps:
(1) The initial dataset upload request, and
(2) data processing that occurs after receiving the response to this initial request.}
}
\value{
list with the following 6 components:
\describe{
  \item{id}{Character: string giving the unique alphanumeric identifier for the dataset}
  \item{numColumns}{Numeric: number of columns in dataset}
  \item{name}{Character: Name of dataset file}
  \item{created}{Character: Time of upload}
  \item{projectId}{Character: string giving the unique alphanumeric identifier for the project}
  \item{numRows}{Numeric: number of rows in dataset}
}
}
\description{
The DataRobot prediction engine requires a CSV file containing the data to be
used in prediction, and this has been implemented here in two ways.
The first and simpler is to specify dataSource as the name of this CSV file,
but for the convenience of those who wish to work with dataframes, this
function also provides the option of specifying a dataframe, which is then
written to a CSV file and uploaded to the DataRobot server.
}

