% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/era-clim.R
\name{wmo_time_consistency}
\alias{wmo_time_consistency}
\title{WMO Time Consistency Test for Pressure, Temperature and Dew Point.}
\usage{
wmo_time_consistency(series, meta = NULL, outpath)
}
\arguments{
\item{series}{A character string giving the path of the input file,
or a 7-column matrix with following columns: variable code, year, month,
day, hour, minute, value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{series} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}
}
\description{
Applicable to a series of sub-daily air pressure (p, mslp),  
air temperature (ta) or dew point temperature (td) observations with at least
some time intervals between observations less or equal to twelve hours. 
Flags the records where
the observations exceed the WMO suggested tolerances for the temperatures and
pressure tendency as function of time period between consecutive reports.
}
\details{
\strong{Input:}
\itemize{
\item A SEF file or a data frame and metadata. The observations data frame
must have seven columns: variable code, year (YYYY), month (MM), day
(DD), hour (HH), minute (MM), observation.
}
\strong{The WMO time consistency test:}
\itemize{
\item WMO suggested tolerances for the temperatures and pressure tendency as
function of time period between consecutive reports (WMO, 1993: VI.21):
\tabular{llllll}{Parameter | \tab dt = 1 hour | \tab dt = 2 hours | \tab dt
= 3 hours | \tab dt = 6 hours | \tab dt = 12 hours \cr ta_tol \tab 4 ºC \tab
7 ºC  \tab 9 ºC \tab 15 ºC  \tab 25 ºC \cr td_tol \tab 4 ºC \tab 6 ºC \tab 8
ºC \tab 12 ºC  \tab 20 ºC \cr pp_tol \tab 3 hPa \tab 6 hPa  \tab 9 hPa \tab 18
hPa \tab 36 hPa \cr}
\item The temperatures tolerance - \emph{ta_tol} and \emph{td_tol} -
considered for 1, 2, 3, 6 and 12 hours is given by the table above.
\item The pressure tolerance \emph{p_tol} is determined for time intervals
belonging to [1, 12] hours, assuming that there is a linear variation of 3
hPa per hour, based in the table above.
\item Time consistency test (WMO, 1993: VI.21):

\eqn{| obs(t) - obs(t - dt) | > tol => flag_obs(t) = suspect and
flag_obs(t-dt) = suspect}

\eqn{obs - observation (ta, td or p), t - hour in decimal, dt - hour
difference in decimal, tol - tolerance}

\item The flag, correspondent to suspect values, is always associated with
two consecutive observations within twelve hours.
}
\strong{Output:}
\itemize{
\item A text file of flagged observations with eight columns: variable code,
year, month, day, hour, minute, value, test.
The test column has the description "wmo_time_consistency".
}
}
\examples{
wmo_time_consistency(series = Bern$p, meta = Meta$p[which(Meta$p$id=="Bern"),],
                     outpath = tempdir())

}
\references{
WMO, 1993: Chapter 6 - Quality Control Procedures. Guide on the Global
Data-processing System, World Meteorological Organization, Geneva, No. 305,
VI.1-VI.27, ISBN 92-63-13305-0.
}
\author{
Clara Ventura, Yuri Brugnara
}
