% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_plot_categorical_vars.R
\name{util_plot_categorical_vars}
\alias{util_plot_categorical_vars}
\title{Utility function to create plots for categorical variables}
\usage{
util_plot_categorical_vars(
  resp_vars,
  group_vars = NULL,
  time_vars = NULL,
  study_data,
  meta_data,
  n_cat_max = 6,
  n_group_max = getOption("dataquieR.max_group_var_levels_in_plot", 20),
  n_data_min = 20
)
}
\arguments{
\item{resp_vars}{name of the categorical variable}

\item{group_vars}{name of the grouping variable}

\item{time_vars}{name of the time variable}

\item{study_data}{the data frame that contains the measurements}

\item{meta_data}{the data frame that contains metadata
attributes of study data}

\item{n_cat_max}{maximum number of categories to be displayed individually
for the categorical variable (\code{resp_vars})}

\item{n_group_max}{maximum number of categories to be displayed individually
for the grouping variable (\code{group_vars}, devices / examiners)}

\item{n_data_min}{minimum number of data points to create a time course plot
for an individual category of the \code{resp_vars} variable}
}
\value{
a figure
}
\description{
Depending on the required level of complexity, this helper function creates
various plots for categorical variables. Next to basic bar plots, it also
enables group comparisons (for example for device/examiner effects) and
longitudinal views.
}
