% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_loess.R
\name{acc_loess}
\alias{acc_loess}
\title{Smoothes and plots adjusted longitudinal measurements and longitudinal trends
from logistic regression models}
\usage{
acc_loess(
  resp_vars,
  group_vars = NULL,
  time_vars,
  co_vars = NULL,
  study_data,
  label_col = VAR_NAMES,
  item_level = "item_level",
  min_obs_in_subgroup = 30,
  resolution = 80,
  comparison_lines = list(type = c("mean/sd", "quartiles"), color = "grey30", linetype =
    2, sd_factor = 0.5),
  mark_time_points = getOption("dataquieR.acc_loess.mark_time_points",
    dataquieR.acc_loess.mark_time_points_default),
  plot_observations = getOption("dataquieR.acc_loess.plot_observations",
    dataquieR.acc_loess.plot_observations_default),
  plot_format = getOption("dataquieR.acc_loess.plot_format",
    dataquieR.acc_loess.plot_format_default),
  meta_data = item_level,
  meta_data_v2,
  n_group_max = getOption("dataquieR.max_group_var_levels_in_plot",
    dataquieR.max_group_var_levels_in_plot_default),
  enable_GAM = getOption("dataquieR.GAM_for_LOESS", dataquieR.GAM_for_LOESS.default),
  exclude_constant_subgroups =
    getOption("dataquieR.acc_loess.exclude_constant_subgroups",
    dataquieR.acc_loess.exclude_constant_subgroups.default)
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the continuous measurement variable}

\item{group_vars}{\link{variable} the name of the observer, device or reader
variable}

\item{time_vars}{\link{variable} the name of the variable giving the time
of measurement}

\item{co_vars}{\link{variable list} a vector of covariables for adjustment, for
example age and sex. Can be NULL (default) for no
adjustment.}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{min_obs_in_subgroup}{\link{integer} (optional argument) If \code{group_vars} is
specified, this argument can be used to specify
the minimum number of observations required for
each of the subgroups. Subgroups with fewer
observations are excluded. The default number
is \code{30}.}

\item{resolution}{\link{numeric} the maximum number of time points used for
plotting the trend lines}

\item{comparison_lines}{\link{list} type and style of lines with which trend
lines are to be compared. Can be mean +/- 0.5
standard deviation (the factor can be specified
differently in \code{sd_factor}) or quartiles
(Q1, Q2, and Q3). Arguments \code{color} and
\code{linetype} are passed to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}.}

\item{mark_time_points}{\link{logical} mark time points with observations
(caution, there may be many marks)}

\item{plot_observations}{\link{logical} show observations as scatter plot in the
background. If there are \code{co_vars} specified,
the values of the observations in the plot will
also be adjusted for the specified covariables.}

\item{plot_format}{\link{enum} AUTO | COMBINED | FACETS | BOTH. Return the plot
as one combined plot for all groups or as
facet plots (one figure per group). \code{BOTH} will
return both variants, \code{AUTO} will decide based
on the number of observers.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{n_group_max}{\link{integer} maximum number of categories to be displayed
individually for the grouping variable (\code{group_vars},
devices / examiners)}

\item{enable_GAM}{\link{logical} Can LOESS computations be replaced by general
additive models to reduce memory consumption  for large
datasets?}

\item{exclude_constant_subgroups}{\link{logical} Should subgroups with constant
values be excluded?}
}
\value{
a \link{list} with:
\itemize{
\item \code{SummaryPlotList}: list with two plots if \code{plot_format = "BOTH"},
otherwise one of the two figures described below:
\itemize{
\item \code{Loess_fits_facets}: The plot contains LOESS-smoothed curves
for each level of the \code{group_vars} in a separate panel. Added trend
lines represent mean and standard deviation or quartiles (specified
in \code{comparison_lines}) for moving windows over the whole data.
\item \code{Loess_fits_combined}: This plot combines all curves into one
panel. Given a low number of levels in the \code{group_vars}, this plot
eases comparisons. However, if the number increases this plot may
be too crowded and unclear.
}
}
}
\description{
The following R implementation executes calculations for quality indicator
"Unexpected location" (see \href{https://dataquality.qihs.uni-greifswald.de/PDQC_DQ_3_2_1_3.html}{here}. Local regression (LOESS) is a versatile statistical method to explore an
averaged course of time series
measurements (Cleveland, Devlin, and Grosse 1988). In context of
epidemiological data, repeated measurements using the same measurement
device or by the same examiner can be considered a time series. LOESS allows
to explore changes in these measurements over time.

\link{Descriptor}
}
\details{
If \code{mark_time_points} or \code{plot_observations} is selected, but would result in
plotting more than 400 points, only a sample of the data will be displayed.

Limitations

The application of LOESS requires model fitting, i.e. the smoothness
of a model is subject to a smoothing parameter (span).
Particularly in the presence of interval-based missing data, high
variability of measurements combined with a low number of
observations in one level of the \code{group_vars} may distort the fit.
Since our approach handles data without knowledge
of such underlying characteristics, finding the best fit is complicated if
computational costs should be minimal. The default of
LOESS in R uses a span of 0.75, which provides in most cases reasonable fits.
The function \code{acc_loess} adapts the span for each level of the \code{group_vars}
(with at least as many observations as specified in \code{min_obs_in_subgroup}
and with at least three time points) based on the respective
number of observations.
LOESS consumes a lot of memory for larger datasets. That is why \code{acc_loess}
switches to a generalized additive model with integrated smoothness
estimation (\code{gam} by \code{mgcv}) if there are 1000 observations or more for
at least one level of the \code{group_vars} (similar to \code{geom_smooth}
from \code{ggplot2}).
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_acc_impl_loess.html}{Online Documentation}
}
