% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_item_missingness.R
\name{com_item_missingness}
\alias{com_item_missingness}
\title{Summarize missingness columnwise (in variable)}
\usage{
com_item_missingness(
  study_data,
  meta_data,
  resp_vars = NULL,
  label_col,
  show_causes = TRUE,
  cause_label_df,
  include_sysmiss = TRUE,
  threshold_value,
  suppressWarnings = FALSE,
  assume_consistent_codes = TRUE,
  expand_codes = assume_consistent_codes,
  drop_levels = TRUE,
  expected_observations = c("HIERARCHY", "ALL", "SEGMENT"),
  pretty_print = TRUE
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{show_causes}{\link{logical} if TRUE, then the distribution of missing codes
is shown}

\item{cause_label_df}{\link{data.frame} missing code table. If missing codes have
labels the respective data frame can be
specified here or in the metadata as
assignments, see \link{cause_label_df}}

\item{include_sysmiss}{\link{logical} Optional, if TRUE system missingness (NAs)
is evaluated in the summary plot}

\item{threshold_value}{\link{numeric} from=0 to=100. a numerical value ranging
from 0-100}

\item{suppressWarnings}{\link{logical} warn about consistency issues with missing
and jump lists}

\item{assume_consistent_codes}{\link{logical} if TRUE and no labels are given and
the same missing/jump code is used
for more than one variable, the
labels assigned for this code are
treated as being be the same for
all variables.}

\item{expand_codes}{\link{logical} if TRUE, code labels are copied from other
variables, if the code is the same and the
label is set somewhere}

\item{drop_levels}{\link{logical} if TRUE, do not display unused missing codes in
the figure legend.}

\item{expected_observations}{\link{enum} HIERARCHY | ALL | SEGMENT. If ALL, all
observations are expected to comprise
all study segments. If SEGMENT, the
\code{PART_VAR} is expected to point
to a variable with values of 0 and 1,
indicating whether the variable was
expected to be observed for each data
row. If HIERARCHY, this is also
checked recursively, so, if a variable
points to such a participation variable,
and that other variable does has also
a \code{PART_VAR} entry pointing
to a variable, the observation of the
initial variable is only
expected, if both segment variables are
1.}

\item{pretty_print}{\link{logical} If FALSE, produce a table that can easily
be processed further, because some cells
feature two numbers (absolute and percentage)
otherwise.}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: data frame about item missingness per response variable
\item \code{SummaryPlot}: ggplot2 heatmap plot, if show_causes was TRUE
\item \code{ReportSummaryTable}: data frame underlying \code{SummaryPlot}
}
}
\description{
Item-Missingness (also referred to as item nonresponse (De Leeuw et al.
2003)) describes the missingness of single values, e.g. blanks or empty data
cells in a data set. Item-Missingness occurs for example in case a respondent
does not provide information for a certain question, a question is overlooked
by accident, a programming failure occurs or a provided answer were missed
while entering the data.
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item Lists of missing codes and, if applicable, jump codes are selected from
the metadata
\item The no. of system missings (NA) in each variable is calculated
\item The no. of used missing codes is calculated for each variable
\item The no. of used jump codes is calculated for each variable
\item Two result dataframes (1: on the level of observations, 2: a summary for
each variable) are generated
\item \emph{OPTIONAL:} if \code{show_causes} is selected, one summary plot for all
\code{resp_vars} is provided
}
}

\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_com_impl_item_missingness.html}{Online Documentation}
}
