/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.decoder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class Base64Encoder {
    private static final int MASK = 63;
    private static final int FIRST_MASK = 0xFC0000;
    private static final int SECOND_MASK = 258048;
    private static final int THIRD_MASK = 4032;
    private static final int FORTH_MASK = 63;
    private static final byte[] ENCODING = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private final byte[] in;
    private final byte[] out;

    public Base64Encoder(int inputBufferSize) {
        this.in = new byte[inputBufferSize];
        int outputBufferSize = (int)Math.floor((float)(4 * inputBufferSize) / 3.0f) + 3;
        outputBufferSize += 2 * (int)Math.floor((float)outputBufferSize / 76.0f);
        this.out = new byte[outputBufferSize];
    }

    public void encode(InputStream inStream, OutputStream outStream) throws IOException {
        int inputLength;
        while ((inputLength = inStream.read(this.in)) > -1) {
            int outputLength = this.encodeInputBuffer(this.in, 0, inputLength);
            if (outputLength <= 0) continue;
            outStream.write(this.out, 0, outputLength);
        }
    }

    private int encodeInputBuffer(byte[] in, int pos, int inputLength) {
        if (inputLength == 0) {
            return 0;
        }
        int inputEnd = pos + inputLength;
        int inputIndex = pos;
        int outputIndex = 0;
        while (inputEnd - inputIndex > 2) {
            int one = this.toInt(in[inputIndex++]) << 16;
            int two = this.toInt(in[inputIndex++]) << 8;
            int three = this.toInt(in[inputIndex++]);
            int quantum = one | two | three;
            int index = (quantum & 0xFC0000) >> 18;
            outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
            index = (quantum & 0x3F000) >> 12;
            outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
            index = (quantum & 0xFC0) >> 6;
            outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
            index = quantum & 0x3F;
            outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
        }
        switch (inputEnd - inputIndex) {
            case 1: {
                int quantum = in[inputIndex++] << 16;
                int index = (quantum & 0xFC0000) >> 18;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                index = (quantum & 0x3F000) >> 12;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                outputIndex = this.setResult(this.out, outputIndex, (byte)61);
                outputIndex = this.setResult(this.out, outputIndex, (byte)61);
                break;
            }
            case 2: {
                int quantum = (in[inputIndex++] << 16) + (in[inputIndex++] << 8);
                int index = (quantum & 0xFC0000) >> 18;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                index = (quantum & 0x3F000) >> 12;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                index = (quantum & 0xFC0) >> 6;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                outputIndex = this.setResult(this.out, outputIndex, (byte)61);
            }
        }
        return outputIndex;
    }

    private int toInt(byte b) {
        return 0xFF & b;
    }

    private int setResult(byte[] results, int outputIndex, byte value) {
        results[outputIndex++] = value;
        outputIndex = this.checkLineLength(results, outputIndex);
        return outputIndex;
    }

    private int checkLineLength(byte[] results, int outputIndex) {
        if (outputIndex == 76 || outputIndex > 76 && ((double)outputIndex - 2.0 * Math.floor((float)outputIndex / 76.0f - 1.0f)) % 76.0 == 0.0) {
            results[outputIndex++] = 13;
            results[outputIndex++] = 10;
        }
        return outputIndex;
    }
}

