% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNode.R
\docType{methods}
\name{MNode}
\alias{MNode}
\alias{MNode,D1Node-method}
\alias{MNode,character-method}
\title{Create a MNode object representing a DataONE Member Node repository.}
\usage{
MNode(x)

\S4method{MNode}{character}(x)

\S4method{MNode}{D1Node}(x)
}
\arguments{
\item{x}{a URI representing a  base URL (i.e. https://knb.ecoinformatics.org/knb/d1/mn/v2); or a reference to a dataone::Node instance}
}
\value{
the MNode object-
}
\description{
Construct an instance of MNode to provide mechanisms to access, create, and update data and 
metadata objects on the associated Member Node.
}
\details{
If the \code{'x'} is a string, it is treated as a URI and an attempt to find an associated
Member Node at that base URL is attempted.  If \code{'x'} is a Node reference, then it is cast to a MNode
instance.  This typically is used from the getMNode() function from the CNode class, which is the preferred
way to retrieve an instance of an MNode.
}
\examples{
mn <- MNode("https://knb.ecoinformatics.org/knb/d1/mn/v2")
}
\seealso{
\code{\link[=MNode-class]{MNode}}{ class description.}
}

