% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{ptaeda2}
\alias{ptaeda2}
\title{Crecimiento en altura de árboles de Pinus taeda (Loblolly pine)}
\format{
Estos datos tienen las siguientes columnas:
\describe{
\item{arbol}{un factor que indica la fuente de semilla del árbol. Esta ordenado acuerdo al valor de la altura.}
\item{edad}{un vector numerico de las edades, en años.}
\item{altura}{la altura total del árbol en cada edad, en m.}
 }
}
\source{
Pinheiro, J. C. and Bates, D. M. (2000) Mixed-effects Models in S and S-PLUS. Springer.
}
\usage{
data(ptaeda2)
}
\description{
Esta dataframe contiene 84 filas y tres columnas del crecimiento en altura de árboles de Pinus taeda. Estos datos
 son un pequenha modificación de la dataframe "Loblolly" del paquete datasets de R.
}
\examples{

data(ptaeda2)
plot(altura ~ edad, data = ptaeda2, subset = arbol== 329,
     xlab = "Edad del arbol (anhos)", las = 1,
     ylab = "Altura (m)",
     main = "Datos de ptaeda2 y ajuste de curva (solo árbol 329)")
m1 <- nls(altura ~ SSasymp(edad, Asym, R0, lrc),
           data = ptaeda2, subset = arbol == 329)
edad <- seq(0, 30, length.out = 101)
lines(edad, predict(m1, list(edad = edad)))
}
\keyword{datasets}
