% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{dgorange}
\alias{dgorange}
\title{Diameter growth of Orange trees}
\format{
A time series data containing the following columns:
\describe{
\item{tree.id}{an ordered factor indicating the tree on which the measurement is made. The ordering is according to increasing maximum diameter.}
\item{time}{a numeric vector giving the numbers of days since 1968/12/31}
\item{girth}{a numeric vector of trunk perimeter (mm). This is probably a circumference at breast height, a standard measurement in forestry.}
\item{dbh}{a numeric vector of diameter at breast height (mm).}
\item{site}{a factor variable, representing site conditions with two levels.}
\item{spp}{a factor variable, representing tree species with three levels.}
 }
}
\source{
The data come from the dataframe 'Orange' of the 'datasets' package, but some columns were
 created for academic reasons only.
}
\usage{
data(dgorange)
}
\description{
Growth diameter measurements for Orange trees. Notice that columns
 site and specie are fictitious and are only created for academic purposes.
}
\examples{
data(dgorange)

coplot(dbh ~ time | tree.id, data = dgorange, show.given = FALSE)
plot(dbh ~ time, data = dgorange, subset = tree.id == 3,
     xlab = "Time (number of days since 1968/12/31)",
     ylab = "Tree diameter (mm)", las = 1)
}
\keyword{datasets}
