% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_data.R
\name{show_data}
\alias{show_data}
\title{Display a table in a window}
\usage{
show_data(data, title = "Imported data", options = NULL, width = "80\%")
}
\arguments{
\item{data}{a data object (either a \code{matrix} or a \code{data.frame}).}

\item{title}{Title to be displayed in window.}

\item{options}{Options passed to \link[DT]{datatable}'s options argument.}

\item{width}{Width of the window.}
}
\value{
No value.
}
\description{
Display a table in a window
}
\examples{

library(shiny)
library(datamods)

ui <- fluidPage(
  actionButton(
    inputId = "show",
    label = "Show data",
    icon = icon("eye")
  )
)

server <- function(input, output, session) {
  observeEvent(input$show, {
    show_data(mtcars, title = "My data")
  })
}

if (interactive())
  shinyApp(ui, server)
}
