% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_func.R
\name{get_api_data}
\alias{get_api_data}
\title{Get data from API Index Name}
\usage{
get_api_data(
  api_index,
  results_per_req = "all",
  filter_by = c(),
  field_select = c(),
  sort_by = c()
)
}
\arguments{
\item{api_index}{Index name of the API}

\item{results_per_req}{Integer number of results to get per request ; "all" would get all the results}

\item{filter_by}{A named character vector of field id (not the name) - value(s) pairs
; can take multiple fields as well as multiple comma separated values}

\item{field_select}{A character vector of fields required in the final data frame}

\item{sort_by}{A character vector of fields to sort by in the final data frame}
}
\value{
data.frame containing the queried data
}
\description{
Using the API index name you got from the API Search/Discovery functions or
from the API list available on data.gov.in, get the data in a convenient way
parsed into a an R-friendly data frame.
}
\examples{
\dontrun{
register_api_key("api_key")

request_data<-get_api_data(api_index="3b01bcb8-0b14-4abf-b6f2-c1bfd384ba69",
     results_per_req=10,filter_by=c(state="Punjab,Haryana",
     district="Amritsar,Ludhiana"),
     field_select=c('state','district','city'),
     sort_by=c('state','district','city'))
}
}
