% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degeneracy_check.R
\name{degeneracy_check}
\alias{degeneracy_check}
\title{Determines if State Matrix is Degenerate for Given Data Set.}
\usage{
degeneracy_check(state_mat, action_vec, cols, data, outcome)
}
\arguments{
\item{state_mat}{Numeric matrix with rows as states and columns as
predictors.}

\item{action_vec}{Numeric vector indicating what action to take for each
state.}

\item{cols}{Optional numeric vector same length as number of columns of the
state matrix (\code{state_mat}) with the action that each column of the
state matrix corresponds to the decision model taking in the previous
period. This is only relevant when the predictor variables of the FSM are
lagged outcomes that include the previous actions taken by that decision
model.}

\item{data}{Numeric matrix that has first col period and rest of cols are
predictors.}

\item{outcome}{Numeric vector same length as the number of rows as data.}
}
\value{
Returns a list of with sparse and corrected state matrix.  If the
  model is fine, then\cr
  \code{sparse_state_mat} and \code{corrected_state_mat}
  should be equal to \code{state_mat}.
}
\description{
\code{degeneracy_check} finds indices for non-identifiable elements of state
matrix and then flips values for those elements and checks changes in
resulting fitness.
}
\details{
\code{degeneracy_check} finds indices for non-identifiable elements of state
matrix and then flips values for those elements and checks changes in
resulting fitness. Being in state/row k (e.g. 2) corresponds to taking action
j (e.g. D). For row k, all entries in the matrix that corresponds to taking
action j last period (e.g. columns 2 and 4 for D) are identifiable; however,
columns that correspond to not taking action j last period (e.g. columns 1
and 3 for D) for the row $k$ that corresponds to taking action j are not
identifiable for a deterministic play of the strategy. For all elements of
the matrix that are not identifiable, the value of the element can be any
integer in the inclusive range of the number of rows of the matrix (e.g. 1 or
2). With empirical data, where the probability that a single deterministic
model generated the data is effectively zero, it is useful to find every
entry in the matrix that would be unidentifiable if the strategy were played
deterministically and then for each element flip it to its opposite value and
test for any change in fitness of the strategy on the data. This function
implements this idea. If there is no change, a sparse matrix is returned
where the the elements in that matrix with a 0 are unidentifiable because
their value makes no difference to the fit of the strategy to the provided
data. If, for each element in the matrix, switching its value led to a
decrease in fitness the following message is displayed, ``Your strategy is a
deterministic approximation of a stochastic process and all of the elements
of the state matrix can be identified.'' If the model is fine, then
\code{sparse_state_mat} and \code{corrected_state_mat} should be equal to
\code{state_mat}.
}
