% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{num_vec}
\alias{num_vec}
\title{Validator: Check if element is a number}
\usage{
num_vec(
  max_len = Inf,
  min_len = 1,
  max_val = Inf,
  min_val = -Inf,
  allowed = NA,
  level = "error",
  allow_na = FALSE,
  allow_dups = TRUE
)
}
\arguments{
\item{max_len}{The maximum length of a numeric element}

\item{min_len}{The minimum length of a numeric element}

\item{max_val}{The maximum value of a numeric element}

\item{min_val}{The minimum value of a numeric element}

\item{allowed}{A vector of allowable values}

\item{level}{Setting "warn" throws a warning, setting "error" halts}

\item{allow_na}{Should NA values be allowed?}

\item{allow_dups}{Should duplicates be allowed?}
}
\value{
A function with the following properties:
\itemize{
\item Checks whether something is a number vector
\item Determines whether the check will throw warning or error
\item Optionally checks for element length
\item Optionally checks for allowable values
\item Optionally checks for max/min
}
}
\description{
This function is used to check whether something is a number. You can use
this function to check the length and min-max of a number vector. You can
also specify the level of a violation. If level is set to "warn" then invalid
inputs will warn you. However, if level is set to "error" then invalid inputs
will abort.
}
\examples{
# Define a dataclass for testing numbers:
my_dataclass <-
  dataclass(
    dte_val = dte_vec(),
    # Setting warn means a warning will occur if violation is found
    # The default is "error" which is stricter and will halt upon violation
    # We also set allowed to 0 and 1 which means elements must be 0 or 1
    num_val = num_vec(level = "warn", allowed = c(0, 1))
  )

# While `dte_val` must be a date, `num_val` must be 0 or 1!
my_dataclass(
  dte_val = Sys.Date(),
  num_val = c(0, 1, 1, 0, 1)
)

my_dataclass(
  dte_val = Sys.Date(),
  num_val = 1
)

# Set min and max requirements!
test_dataclass <-
  dataclass(
    num = num_vec(min_val = 1, max_val = 100)
  )

# Value must be between 1 and 10 inclusive!
test_dataclass(num = 10.03012)
}
