% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_video.R
\name{download_video}
\alias{download_video}
\title{Download Video From Databrary.}
\usage{
download_video(
  asset_id = 1,
  session_id = 9807,
  file_name = tempfile(paste0(session_id, "_", asset_id, "_"), fileext = ".mp4"),
  target_dir = tempdir(),
  vb = FALSE,
  rq = NULL
)
}
\arguments{
\item{asset_id}{Asset id for target file.}

\item{session_id}{Slot/session number where target file is stored.}

\item{file_name}{Name for downloaded file.}

\item{target_dir}{Directory to save the downloaded file.
Default is a temporary directory given by a call to \code{tempdir()}.}

\item{vb}{A Boolean value. If TRUE provides verbose output.}

\item{rq}{An \code{httr2} request object.}
}
\value{
Full file name to the asset.
}
\description{
Download Video From Databrary.
}
\examples{
\donttest{
\dontrun{
download_video() # Download's 'numbers' file from volume 1.
download_video(asset_id = 11643, session_id = 9825, file_name = "rdk.mp4")
#' # Downloads a display with a random dot kinematogram (RDK).
}
}

}
