% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructNWISURL.R
\name{constructUseURL}
\alias{constructUseURL}
\title{Construct URL for NWIS water use data service}
\usage{
constructUseURL(years, stateCd, countyCd, categories)
}
\arguments{
\item{years}{integer Years for data retrieval. Must be years ending in 0 or 5,
or "ALL", which retrieves all available years.}

\item{stateCd}{could be character (full name, abbreviation, id), or numeric (id)}

\item{countyCd}{could be numeric (County IDs from countyCdLookup) or character ("ALL")}

\item{categories}{character Two-letter cateogory abbreviation(s)}
}
\value{
url string
}
\description{
Reconstructs URLs to retrieve data from here: \url{https://waterdata.usgs.gov/nwis/wu}
}
\examples{
url <- constructUseURL(
  years = c(1990, 1995),
  stateCd = "Ohio",
  countyCd = c(1, 3),
  categories = "ALL"
)

}
