% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importNGWMN_wml2.R
\name{importNGWMN}
\alias{importNGWMN}
\title{Function to return data from the National Ground Water Monitoring Network waterML2 format}
\usage{
importNGWMN(input, asDateTime = FALSE, tz = "UTC")
}
\arguments{
\item{input}{character or raw, containing the url for the retrieval or a path to the data file, or raw XML.}

\item{asDateTime}{logical, if \code{TRUE} returns date and time as POSIXct, if \code{FALSE}, character}

\item{tz}{character to set timezone attribute of dateTime. Default is "UTC", and converts the 
date times to UTC, properly accounting for daylight savings times based on the data's provided time zone offset.
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage", as well as the following which do not use daylight savings time: "America/Honolulu",
"America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla". See also  \code{OlsonNames()} 
for more information on time zones.}
}
\value{
mergedDF a data frame source, time, value, uom, uomTitle, comment, gmlID
}
\description{
This function accepts a url parameter for a WaterML2 getObservation. This function is still under development,
but the general functionality is correct.
}
\examples{
\donttest{
obs_url <- paste("https://cida.usgs.gov/ngwmn_cache/sos?request=GetObservation",
"service=SOS","version=2.0.0",
"observedProperty=urn:ogc:def:property:OGC:GroundWaterLevel",
"responseFormat=text/xml",
"featureOfInterest=VW_GWDP_GEOSERVER.USGS.403836085374401",sep="&")

 data_returned <- importNGWMN(obs_url)

}

}
