% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whatNWISsites.R
\name{whatNWISsites}
\alias{whatNWISsites}
\title{Site Data Import from NWIS}
\usage{
whatNWISsites(...)
}
\arguments{
\item{\dots}{see \url{https://waterservices.usgs.gov/rest/Site-Service.html#Service} for a complete list of options. A 
list (or lists) can also be supplied.}
}
\value{
A data frame with at least the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency_cd \tab character \tab The NWIS code for the agency reporting the data\cr
site_no \tab character \tab The USGS site number \cr
station_nm \tab character \tab Station name \cr
site_tp_cd \tab character \tab Site type code \cr
dec_lat_va \tab numeric \tab Decimal latitude \cr
dec_long_va \tab numeric \tab Decimal longitude \cr
queryTime \tab POSIXct \tab Query time \cr
}

There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
}
}
\description{
Returns a list of sites from the NWIS web service. This function gets the data from: \url{https://waterservices.usgs.gov/rest/Site-Test-Tool.html}.
Arguments to the function should be based on \url{https://waterservices.usgs.gov/rest/Site-Service.html#Service}
Mapper format is used
}
\examples{
\dontrun{
siteListPhos <- whatNWISsites(stateCd="OH",parameterCd="00665")
oneSite <- whatNWISsites(sites="05114000")
}
}
