% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getNWISqwData}
\alias{getNWISqwData}
\title{Raw Data Import for USGS NWIS QW Data}
\usage{
getNWISqwData(siteNumber, pCodes, startDate, endDate, expanded = FALSE,
  interactive = TRUE)
}
\arguments{
\item{siteNumber}{string or vector of of USGS site numbers.  This is usually an 8 digit number}

\item{pCodes}{string or vector of USGS parameter code.  This is usually an 5 digit number.}

\item{startDate}{string starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{string ending date for data retrieval in the form YYYY-MM-DD.}

\item{expanded}{logical defaults to FALSE. If TRUE, retrieves additional information. Expanded data includes
remark_cd (remark code), result_va (result value), val_qual_tx (result value qualifier code), meth_cd (method code),
dqi_cd (data-quality indicator code), rpt_lev_va (reporting level), and rpt_lev_cd (reporting level type).}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
data dataframe with agency, site, dateTime, value, and code columns
}
\description{
Imports data from NWIS web service. This function gets the data from here: \url{http://nwis.waterdata.usgs.gov/nwis/qwdata}
A list of parameter codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/pmcodes/}
A list of statistic codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}
}
\examples{
# These examples require an internet connection to run
siteNumber <- c('04024430','04024000')
startDate <- '2010-01-01'
endDate <- ''
pCodes <- c('34247','30234','32104','34220')
rawNWISqwData <- getNWISqwData(siteNumber,pCodes,startDate,endDate)
rawNWISqwDataExpand <- getNWISqwData(siteNumber,pCodes,startDate,endDate,expanded=TRUE)
# To get data in Sample dataframe format:
dataColumns <- grep("p\\\\d{5}",names(rawNWISqwData))
remarkColumns <- grep("r\\\\d{5}",names(rawNWISqwData))
totalColumns <-c(grep("sample_dt",names(rawNWISqwData)), dataColumns, remarkColumns)
totalColumns <- totalColumns[order(totalColumns)]
compressedData <- compressData(rawNWISqwData[,totalColumns])
Sample <- populateSampleColumns(compressedData)
}
\seealso{
\code{\link{getWQPData}}, \code{\link{getWQPSites}},
\code{\link{getWQPqwData}}, \code{\link{constructNWISURL}}
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

