% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods.R
\name{GetAttribute}
\alias{GetAttribute}
\title{Get an attribute from a Node.}
\usage{
GetAttribute(node, attribute, ..., format = FALSE,
  inheritFromAncestors = FALSE, nullAsNa = TRUE)
}
\arguments{
\item{node}{The \code{\link{Node}} from which the \code{attribute} should be fetched.}

\item{attribute}{determines what is collected. The \code{attribute} can be
\itemize{
  \item a.) the name of a \bold{field} or a \bold{property/active} of each \code{Node} in the tree, e.g. \code{acme$Get("p")} or \code{acme$Get("position")}
  \item b.) the name of a \bold{method} of each \code{Node} in the tree, e.g. \code{acme$Get("levelZeroBased")}, where e.g. \code{acme$levelZeroBased <- function() acme$level - 1}
  \item c.) a \bold{function}, whose first argument must be a \code{Node} e.g. \code{acme$Get(function(node) node$cost * node$p)}
 }}

\item{...}{in case the \code{attribute} is a function or a method, the ellipsis is passed to it as additional arguments.}

\item{format}{if \code{FALSE} (the default), no formatting is being used. If \code{TRUE}, then the first formatter (if any) found along the ancestor path is being used for formatting 
(see \code{\link{SetFormat}}). If \code{format} is a function, then the collected value is passed to that function, and the result is returned.}

\item{inheritFromAncestors}{if \code{TRUE}, then the path above a \code{Node} is searched to get the \code{attribute} in case it is NULL.}

\item{nullAsNa}{If TRUE (the default), then NULL is returned as NA. Otherwise it is returned as NULL.}
}
\description{
Get an attribute from a Node.
}
\examples{
data(acme)
GetAttribute(acme$IT$Outsource, "cost")

}

