% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.dist.ind.snp.r
\name{utils.dist.ind.snp}
\alias{utils.dist.ind.snp}
\title{Calculates a distance matrix for individuals defined in a dartR
genlight object using SNP data (DArTseq)}
\usage{
utils.dist.ind.snp(
  x,
  method = "Euclidean",
  scale = FALSE,
  output = "dist",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight containing the genotypes [required].}

\item{method}{Specify distance measure [default Euclidean].}

\item{scale}{If TRUE and method='Euclidean', the distance will be scaled to 
fall in the range [0,1] [default FALSE].}

\item{output}{Specify the format and class of the object to be returned, 
dist for a object of class dist, matrix for an object of class matrix [default "dist"].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report [default 2].}
}
\value{
An object of class 'dist' or 'matrix' giving distances between individuals
}
\description{
This script calculates various distances between individuals based on 
SNP genotypes.
}
\details{
The distance measure can be one of:
 \itemize{
  \item Euclidean -- Euclidean Distance applied to Cartesian coordinates defined
  by the loci, scored as 0, 1 or 2. 
 \item Simple -- simple mismatch, 0 where no alleles are shared, 1 where one
 allele is shared, 2 where both alleles are shared. 
 \item Absolute -- absolute mismatch, 0 where no alleles are shared, 1 where
 one or both alleles are shared.
 \item Czekanowski (or Manhattan) calculates the city block metric distance
 by summing the scores on each axis (locus).
 }
}
\examples{
 \donttest{
D <- utils.dist.ind.snp(testset.gl, method='Manhattan')
D <- utils.dist.ind.snp(testset.gl, method='Euclidean',scale=TRUE)
}
D <- utils.dist.ind.snp(testset.gl, method='Simple')

}
\author{
Author(s): Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
