% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.print.history.r
\name{gl.print.history}
\alias{gl.print.history}
\title{Prints history of a genlight object}
\usage{
gl.print.history(x = NULL, history = NULL)
}
\arguments{
\item{x}{A genlight object (with history) [optional].}

\item{history}{Either a link to a history slot
(gl\@other$history), or a vector indicating which part of the history of x is
used [c(1,3,4) uses the first, third and forth entry from x\@other$history].
If no history is provided the complete history of x is used (recreating the
identical object x) [optional].}
}
\value{
Prints a table with all history records. Currently the style cannot
be changed.
}
\description{
Prints history of a genlight object
}
\examples{
\donttest{
dartfile <- system.file('extdata','testset_SNPs_2Row.csv', package='dartR')
metadata <- system.file('extdata','testset_metadata.csv', package='dartR')
gl <- gl.read.dart(dartfile, ind.metafile = metadata, probar=FALSE)
gl2 <- gl.filter.callrate(gl, method='loc', threshold=0.9)
gl3 <- gl.filter.callrate(gl2, method='ind', threshold=0.95)
#Now 'replay' part of the history 'onto' another genlight object
#bc.fil <- gl.play.history(gl.compliance.check(bandicoot.gl),
#history=gl3@other$history[c(2,3)], verbose=1)
#gl.print.history(bc.fil)
}
}
\author{
Bernd Gruber (bugs? Post to
\url{https://groups.google.com/d/forum/dartr})
}
