% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.pcoa.plot.3d.r
\name{gl.pcoa.plot.3d}
\alias{gl.pcoa.plot.3d}
\title{3D interactive plot of the results of a PCoA ordination}
\usage{
gl.pcoa.plot.3d(
  glPca,
  x,
  xaxis = 1,
  yaxis = 2,
  zaxis = 3,
  radius = 8,
  verbose = NULL
)
}
\arguments{
\item{glPca}{-- name of the glPca object containing the factor scores and eigenvalues [required]}

\item{x}{-- name of the genlight object or fd object from which the PCoA was generated [required]}

\item{xaxis}{-- identify the x axis from those available in the ordination (xaxis <= nfactors) [default 1]}

\item{yaxis}{-- identify the y axis from those available in the ordination (yaxis <= nfactors) [default 2]}

\item{zaxis}{-- identify the z axis from those available in the ordination (zaxis <= nfactors) [default 3]}

\item{radius}{-- size of the points [default 8]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
NULL, plots an interactive 3D plot of the ordination in a separate window
}
\description{
This script takes output from the ordination undertaken using gl.pcoa() and plots the individuals in 3D space. The visualisation
can be rotated, zoomed in and zoomed out with the mouse to examine the structure.
}
\details{
The factor scores are taken from the output of gl.pcoa(), an object of class glPca, and the population assignments from the original data file
and plots the specimens in a 3D plot.

Axes can be specified from the ordination, provided they are within the range of the nfactors value provided to gl.pcoa().
}
\examples{
pcoa <- gl.pcoa(possums.gl, nfactor=5)
gl.pcoa.plot.3d(pcoa, possums.gl, xaxis=1, yaxis=2, zaxis=3)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
