% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sexlinkage.r
\name{gl.sexlinkage}
\alias{gl.sexlinkage}
\title{Identify loci that are sex linked in specimens in a genlight \{adegenet\} object}
\usage{
gl.sexlinkage(x, t.het = 0, t.hom = 0, v = 2)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{t.het}{-- tolerance, that is tm=0.05 means that 5% of the heterogametic sex can be homozygous and still 
be regarded as consistent with a sex specific marker [default 0]}

\item{t.hom}{-- tolerance, that is tf=0.05 means that 5% of the homogametic sex can be heterozygous and still
be regarded as consistent with a sex specific marker [default 0]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
The list of sex specific loci
}
\description{
Alleles unique to the Y or W chromosome and monomorphic on the X chromosomes will appear in the SNP dataset as 
genotypes that are heterozygotic in all individuals of the heterogametic sex and homozygous in all individuals 
of the homogametic sex.
}
\details{
This script will identify loci with alleles that behave in this way, as putative sex specific SNP markers.

Sex of the individuals for which sex is known with certainty is to be held in the variable x@other$ind.metrics$sex, 
as M for male, F for female, NA otherwise. The script abbreviates the entries here to the first character. So coding of "Female" and "Male" works as well. Character are also converted to upper cases.
}
\examples{
result <- gl.sexlinkage(testset.gl)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
