% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.maf.r
\name{gl.report.maf}
\alias{gl.report.maf}
\title{Report minor allele frequency for loci}
\usage{
gl.report.maf(gl, minind = 5, plot = TRUE)
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP data [required]}

\item{minind}{-- minimum number of individuals required to calculate the minor allele frequency. Please note allelefrequncies for such loci are still reported, but a warning is issued if the number is below minind.}

\item{plot}{-- switch if a histogram of the distribution of allele frequencies should be provided}
}
\value{
the functions returns a list with two slots (vectors). maf contains the minor allele frequency and n the number of individuals the minor allele frequency is based on.
}
\description{
Minor allele frequencies are reported for every loci. Also the number of individuals that have been used to calculate allele frequencies are reported to be able to discard frequencies of loci where only a few individuals are available.
}
\examples{
frequ <- gl.report.maf(testset.gl)
summary(frequ$maf)
summary(frequ$n)
}
\author{
Bernd Gruber (glbugs@aerg.canberra.edu.au)
}
