% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightUpdateFunctions.R
\name{maxoutWeightUpdate}
\alias{maxoutWeightUpdate}
\title{Updates the weight on maxout layers}
\usage{
maxoutWeightUpdate(darch, layerIndex, weightsInc, biasesInc, ...,
  weightDecay = getParameter(".darch.weightDecay", 0, darch),
  poolSize = getParameter(".darch.maxout.poolSize", 2, darch))
}
\arguments{
\item{darch}{\linkS4class{DArch} instance.}

\item{layerIndex}{Layer index within the network.}

\item{weightsInc}{Matrix containing scheduled weight updates from the
fine-tuning algorithm.}

\item{biasesInc}{Bias weight updates.}

\item{...}{Additional parameters, not used.}

\item{weightDecay}{Weights are multiplied by (1 - \code{weightDecay}) before
each update. Corresponds to the \code{darch.weightDecay} parameter of
\link{darch.default}.}

\item{poolSize}{Size of maxout pools, see parameter
\code{darch.maxout.poolSize} of \code{\link{darch}}.}
}
\value{
The updated weights.
}
\description{
On maxout layers, only the weights of active units are altered, additionally
all weights within a pool must be the same.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, c(0, 50, 0),
 darch.unitFunction = c("maxoutUnit", "softmaxUnit"),
 darch.maxout.poolSize = 5, darch.maxout.unitFunction = "sigmoidUnit",
 darch.weightUpdateFunction = c("weightDecayWeightUpdate", "maxoutWeightUpdate"))
}
}
\references{
Goodfellow, Ian J., David Warde-Farley, Mehdi Mirza, Aaron C. Courville,
 and Yoshua Bengio (2013). "Maxout Networks". In: Proceedings of the 30th
 International Conference on Machine Learning, ICML 2013, Atlanta, GA, USA,
 16-21 June 2013, pp. 1319-1327.
 URL: http://jmlr.org/proceedings/papers/v28/goodfellow13.html
}
\seealso{
Other weight update functions: \code{\link{weightDecayWeightUpdate}}
}

