% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darchUnitFunctions.R
\name{maxoutUnit}
\alias{maxoutUnit}
\title{Maxout / LWTA unit function}
\usage{
maxoutUnit(input, ..., poolSize = getParameter(".darch.maxout.poolSize", 2,
  ...), unitFunc = getParameter(".darch.maxout.unitFunction", linearUnit,
  ...), dropoutMask = vector())
}
\arguments{
\item{input}{Input for the activation function.}

\item{...}{Additional parameters, passed on to inner unit function.}

\item{poolSize}{The size of each maxout pool.}

\item{unitFunc}{Inner unit function for maxout.}

\item{dropoutMask}{Vector containing the dropout mask.}
}
\value{
A list with the maxout activation in the first entry and the 
  derivative of the transfer function in the second entry.
}
\description{
The function calculates the activation of the units and returns a list, in 
which the first entry is the result through the maxout transfer function and 
the second entry is the derivative of the transfer function.
}
\details{
Maxout sets the activations of all neurons but the one with the highest
activation within a pool to \code{0}. If this is used without
\link{maxoutWeightUpdate}, it becomes the local-winner-takes-all algorithm,
as the only difference between the two is that outgoing weights are shared
for maxout.
}
\examples{
\dontrun{
data(iris)
# LWTA:
model <- darch(Species ~ ., iris, c(0, 50, 0),
 darch.unitFunction = c("maxoutUnit", "softmaxUnit"),
 darch.maxout.poolSize = 5, darch.maxout.unitFunction = "sigmoidUnit")
# Maxout:
model <- darch(Species ~ ., iris, c(0, 50, 0),
 darch.unitFunction = c("maxoutUnit", "softmaxUnit"),
 darch.maxout.poolSize = 5, darch.maxout.unitFunction = "sigmoidUnit",
 darch.weightUpdateFunction = c("weightDecayWeightUpdate", "maxoutWeightUpdate"))
}
}
\references{
Srivastava, Rupesh Kumar, Jonathan Masci, Sohrob Kazerounian,
 Faustino Gomez, and Juergen Schmidhuber (2013). "Compete to Compute". In:
 Advances in Neural Information Processing Systems 26. Ed. by C.J.C. Burges,
 L. Bottou, M. Welling, Z. Ghahramani, and K.Q. Weinberger.
 Curran Associates, Inc., pp. 2310-2318.
 URL: http://papers.nips.cc/paper/5059-compete-to-compute.pdf
 
 Goodfellow, Ian J., David Warde-Farley, Mehdi Mirza, Aaron C. Courville,
 and Yoshua Bengio (2013). "Maxout Networks". In: Proceedings of the 30th
 International Conference on Machine Learning, ICML 2013, Atlanta, GA, USA,
 16-21 June 2013, pp. 1319-1327.
 URL: http://jmlr.org/proceedings/papers/v28/goodfellow13.html
}
\seealso{
Other darch unit functions: \code{\link{exponentialLinearUnit}},
  \code{\link{linearUnit}},
  \code{\link{rectifiedLinearUnit}},
  \code{\link{sigmoidUnit}}, \code{\link{softmaxUnit}},
  \code{\link{softplusUnit}}, \code{\link{tanhUnit}}
}

