% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateWeightsFunctions.R
\name{generateWeightsGlorotNormal}
\alias{generateWeightsGlorotNormal}
\title{Glorot normal weight initialization}
\usage{
generateWeightsGlorotNormal(numUnits1, numUnits2,
  weights.mean = getParameter(".weights.mean", 0, ...), ...)
}
\arguments{
\item{numUnits1}{Number of units in the lower layer.}

\item{numUnits2}{Number of units in the upper layer.}

\item{weights.mean}{\code{mean} parameter to the \link{rnorm} function.}

\item{...}{Additional parameters, used for parameter resolution and passed
to \code{\link{generateWeightsNormal}}.}
}
\value{
Weight matrix.
}
\description{
This function is used to generate random weights and biases using
Glorot normal weight initialization as described in
Glorot & Bengio, AISTATS 2010.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, generateWeightsFunction = "generateWeightsGlorotNormal",
 weights.mean = .1)
}
}
\references{
Glorot, Xavier and Yoshua Bengio (2010). "Understanding the
 difficulty of training deep feedforward neural networks".
 In: International conference on artificial intelligence and statistics, pp. 249-256
}
\seealso{
Other weight generation functions: \code{\link{generateWeightsGlorotUniform}},
  \code{\link{generateWeightsHeNormal}},
  \code{\link{generateWeightsHeUniform}},
  \code{\link{generateWeightsNormal}},
  \code{\link{generateWeightsUniform}}
}

