% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_groupedbar}
\alias{plot_groupedbar}
\title{Plot grouped bar}
\usage{
plot_groupedbar(data, label_x = "", label_y = "", colors = NULL, alpha = 1)
}
\arguments{
\item{data}{data.frame contain x, value, and variable}

\item{label_x}{x-axis label}

\item{label_y}{y-axis label}

\item{colors}{color vector}

\item{alpha}{level of transparency}
}
\value{
returns a ggplot graphic
}
\description{
This function generates a grouped bar plot from a given data frame using ggplot2.
}
\examples{
#summarizing iris dataset
data <- iris |> dplyr::group_by(Species) |>
 dplyr::summarize(Sepal.Length=mean(Sepal.Length), Sepal.Width=mean(Sepal.Width))
head(data)

#ploting data
grf <- plot_groupedbar(data, colors=c("blue", "red"))
plot(grf)
}
